/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

class AuditTrail {
    private boolean auditFlag = false;
    private String auditFileName = null;
    private String module = null;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    PrintStream outFile = null;

    public AuditTrail(String module) {
        this.module = module;
    }

    public boolean auditing() {
        return this.auditFlag;
    }

    public void setAudit(boolean auditFlag) {
        this.auditFlag = auditFlag;
    }

    public void setAuditFile(String fileName) {
        System.out.println("setAuditTrail..." + fileName);
        this.auditFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String text) {
        if (!this.auditFlag || text == null || text.length() <= 0) {
            return;
        }
        try {
            if (this.outFile == null) {
                this.outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.auditFileName, true)));
            }
            String outText = this.dateFormatter.format(new Date()) + " (" + this.module + ") " + text;
            this.outFile.println(outText);
            this.outFile.flush();
        }
        catch (Exception exception) {}
    }

    public void printStrings(String desc, String[] strs) {
        StringBuffer buf = new StringBuffer(desc);
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                buf.append(strs[i]);
            }
        }
        this.println(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printException(String location, Exception ex) {
        if (!this.auditFlag || ex == null) {
            return;
        }
        try {
            if (this.outFile == null) {
                this.outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.auditFileName, true)));
            }
            String outText = this.dateFormatter.format(new Date()) + " (" + this.module + ") EXCEPTION @ " + location;
            this.outFile.println(outText);
            ex.printStackTrace(this.outFile);
            this.outFile.flush();
        }
        catch (Exception exception) {}
    }

    protected void finalize() {
        if (this.outFile != null) {
            this.outFile.close();
        }
        this.outFile = null;
    }
}

